*** Table 5: Whites' Attitude from the ANES

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 


*** OPEN MAIN ANES DTA (STATE-LEVEL)
use  "$data/main_ANES.dta", clear

keep if white==1
keep if mover==0


global county_c 	dem_40 fr_bl40 mf_sh40 urb_sh40 pct_CIO_39
global ind_c 		i.age female i.educ_mycodes married

****************************************************************

cd "$output"

* col. 1 
ivreg2 therm_blks (D6040_fr_bl=Z_40to60_p40) $county_c $ind_c i.region [aw=weight] , cl(statefip) ffirst savefirst
local F=e(widstat)
      su therm_dems [aw=weight] if e(sample)
      local mout=round(r(mean), .001)
      su D6040_fr_bl [aw=weight] if e(sample)
      local mtr=round(r(mean), .001)
      su D6040_fr_bl [aw=weight] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table5_A.xls, excel nocon replace ///
keep (D6040_fr_bl)  dec(3) addstat( "F-stat", `F')  addtext(Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D6040_fr_bl
outreg2 using Table5_B.xls, excel nocon replace ///
keep (Z_40to60_p40)  dec(3)


* cols. 2 and 3 
foreach i in NAACP dems  {
    
ivreg2 therm_`i' (D6040_fr_bl=Z_40to60_p40) $county_c $ind_c i.region [aw=weight] , cl(statefip) ffirst savefirst
local F=e(widstat)
      su therm_`i' [aw=weight] if e(sample)
      local mout=round(r(mean), .001)
      su D6040_fr_bl [aw=weight] if e(sample)
      local mtr=round(r(mean), .001)
      su D6040_fr_bl [aw=weight] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table5_A.xls, excel nocon append ///
keep (D6040_fr_bl)  dec(3) addstat( "F-stat", `F')  addtext(Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D6040_fr_bl
outreg2 using Table5_B.xls, excel nocon append ///
keep (Z_40to60_p40)  dec(3)

}



* col. 4 
ivreg2 mip_pro_integr (D6040_fr_bl=Z_40to60_p40) $county_c $ind_c i.year i.region  [aw=weight], cl(statefip) first savefirst
local F=e(widstat)
      su mip_pro_integr [aw=weight] if e(sample)
      local mout=round(r(mean), .001)
      su D6040_fr_bl [aw=weight] if e(sample)
      local mtr=round(r(mean), .001)
      su D6040_fr_bl [aw=weight] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table5_A.xls, excel nocon append ///
keep (D6040_fr_bl)  dec(3) addstat( "F-stat", `F')  addtext( Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D6040_fr_bl
outreg2 using  Table5_B.xls, excel nocon append ///
keep (Z_40to60_p40)  dec(3)  


* col. 5 
ivreg2 cong_dem (D6040_fr_bl =   Z_40to60_p40) i.region $county_c $ind_c  i.year [aw=weight] if year>1955, cl(statefip) ffirst savefirst
local F=e(widstat)
      su cong_dem [aw=weight] if e(sample)
      local mout=round(r(mean), .001)
      su D6040_fr_bl [aw=weight] if e(sample)
      local mtr=round(r(mean), .001)
      su D6040_fr_bl [aw=weight] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table5_A.xls, excel nocon append ///
keep ( D6040_fr_bl)  dec(3) addstat( "F-stat", `F')  addtext( Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D6040_fr_bl
outreg2 using Table5_B.xls, excel nocon append ///
keep ( Z_40to60_p40)  dec(3) 


* col. 6 
ivreg2 cong_dem (D6040_fr_bl =   Z_40to60_p40)  $county_c $ind_c  i.year i.region [aw=weight] if year==1964, cl(statefip) ffirst savefirst
local F=e(widstat)
      su cong_dem [aw=weight] if e(sample)
      local mout=round(r(mean), .001)
      su D6040_fr_bl [aw=weight] if e(sample)
      local mtr=round(r(mean), .001)
      su D6040_fr_bl [aw=weight] if e(sample)
      local sdtr=round(r(sd), .001)
outreg2 using Table5_A.xls, excel nocon append ///
keep ( D6040_fr_bl)  dec(3) addstat( "F-stat", `F')  addtext( Avg. outcome,`mout',Avg. treatment,`mtr',S.d. treatment,`sdtr')

est restore _ivreg2_D6040_fr_bl
outreg2 using Table5_B.xls, excel nocon append ///
keep ( Z_40to60_p40)  dec(3) 



